<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Bots;
use yii\db\Expression;

/**
 * BotsSearch represents the model behind the search form about `common\models\Bots`.
 */
class HoneypotsSearch extends Bots
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'status', 'priority', 'type'], 'integer'],
            [['id'],'integer','max'=>2147483647],
            [['status','priority'],'integer','max'=>32],
            [['bot', 'tz', 'country', 'arch', 'cname', 'path', 'uname', 'comps', 'av', 'group', 'trust', 'net', 'os', 'osbuild', 'domain', 'soft', 'created_at', 'updated_at', 'ip', 'locale', 'ps', 'source', 'comment'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        
        $accessFilter = json_decode(Yii::$app->user->identity->groups);
        $query = Bots::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        if (Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            $query->andFilterWhere(['group' => $accessFilter]);
        }

        
        $query->andFilterWhere(['type' => 1]);
        

        $dataProvider->sort->attributes['updated_at'] = [
            'asc' => [new Expression('bots.updated_at ASC NULLS FIRST')],
            'desc' => [new Expression('bots.updated_at DESC NULLS LAST')]
        ];
        $dataProvider->sort->defaultOrder = ['updated_at' => SORT_DESC];


        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'status' => $this->status,
            'priority' => $this->priority,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'type' => $this->type,
        ]);

        $query->andFilterWhere(['like', 'bot', $this->bot])
            ->andFilterWhere(['like', 'country', $this->country])
            ->andFilterWhere(['like', 'arch', $this->arch])
            ->andFilterWhere(['like', 'cname', $this->cname])
            ->andFilterWhere(['like', 'path', $this->path])
            ->andFilterWhere(['like', 'uname', $this->uname])
            ->andFilterWhere(['like', 'comps', $this->comps])
            ->andFilterWhere(['like', 'av', $this->av])
            ->andFilterWhere(['like', 'group', $this->group])
            ->andFilterWhere(['like', 'trust', $this->trust])
            ->andFilterWhere(['like', 'net', $this->net])
            ->andFilterWhere(['like', 'domain', $this->domain])
            ->andFilterWhere(['like', 'soft', $this->soft])
            ->andFilterWhere(['like', 'ip', $this->ip])
            ->andFilterWhere(['like', 'locale', $this->locale])
            ->andFilterWhere(['like', 'ps', $this->ps])
            ->andFilterWhere(['like', 'source', $this->source])
            ->andFilterWhere(['like', 'comment', $this->comment])
            ->andFilterWhere(['like', 'os', $this->os])
            ->andFilterWhere(['like', 'tz', $this->tz])
            ->andFilterWhere(['like', 'osbuild', $this->osbuild]);
        return $dataProvider;
    }
}
